<!--- This file is part of Mura CMS.

Mura CMS is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, Version 2 of the License.

Mura CMS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mura CMS. If not, see <http://www.gnu.org/licenses/>.

Linking Mura CMS statically or dynamically with other modules constitutes
the preparation of a derivative work based on Mura CMS. Thus, the terms and 	
conditions of the GNU General Public License version 2 (GPL) cover the entire combined work.

However, as a special exception, the copyright holders of Mura CMS grant you permission
to combine Mura CMS with programs or libraries that are released under the GNU Lesser General Public License version 2.1.

In addition, as a special exception, the copyright holders of Mura CMS grant you permission
to combine Mura CMS with independent software modules that communicate with Mura CMS solely
through modules packaged as Mura CMS plugins and deployed through the Mura CMS plugin installation API,
provided that these modules (a) may only modify the /trunk/www/plugins/ directory through the Mura CMS
plugin installation API, (b) must not alter any default objects in the Mura CMS database
and (c) must not alter any files in the following directories except in cases where the code contains
a separately distributed license.

/trunk/www/admin/
/trunk/www/tasks/
/trunk/www/config/
/trunk/www/requirements/mura/

You may copy and distribute such a combined work under the terms of GPL for Mura CMS, provided that you include
the source code of that other code when and as the GNU GPL requires distribution of source code.

For clarity, if you create a modified version of Mura CMS, you are not obligated to grant this special exception
for your modified version; it is your choice whether to do so, or to make such modified version available under
the GNU General Public License version 2 without this exception. You may, if you choose, apply this exception
to your own modified versions of Mura CMS.
--->

<cfsetting enablecfoutputonly="YES">

<!--- TAG PARAMETERS --->
<cfparam name="Attributes.Query">  
<cfparam name="Attributes.Display1">
<cfparam name="Attributes.Display2">
<cfparam name="Attributes.Value1" default="#Attributes.Display1#">
<cfparam name="Attributes.Value2" default="#Attributes.Display2#">
<cfparam name="Attributes.Default1" default="(((((none)))))">
<cfparam name="Attributes.Default2" default="(((((none)))))">
<cfparam name="Attributes.Name1" default="TwoSelectsRelated1">
<cfparam name="Attributes.Name2" default="TwoSelectsRelated2">
<cfparam name="Attributes.Size1" default="1">
<cfparam name="Attributes.Size2" default="1">
<cfparam name="Attributes.Class" default="">
<cfparam name="Attributes.ForceWidth1" default="">
<cfparam name="Attributes.ForceWidth2" default="">
<cfparam name="Attributes.ForceWidthChar" default="&nbsp;">
<cfparam name="Attributes.EmptyText1" default="">
<cfparam name="Attributes.EmptyText2" default="">
<cfparam name="Attributes.Message1" default="You must choose an option for #Attributes.Name1#.">
<cfparam name="Attributes.Message2" default="You must choose an option for #Attributes.Name2#.">
<cfparam name="Attributes.FormName" default="forms[0]">
<cfparam name="Attributes.HTMLBetween" default="">
<cfparam name="Attributes.OnChange" default="">
<cfparam name="Attributes.ExtraOptions2" default="#IIF((Attributes.EmptyText1 EQ "") AND (Attributes.Size2 EQ 1), 0, 5)#">
<cfparam name="Attributes.AutoSelectFirst" default="Yes">



<cfset FunctionName = ReplaceList(Attributes.FormName, "[,]", ",") & Attributes.Name1 & "ChangeMenu()">


<!--- "MAGIC" SHORTCUTS FOR THE ONCHANGE HANDLER --->
<cfif Attributes.OnChange is "Jump!">
  <cfset Attributes.OnChange = "document.location = this.options[selectedIndex].value;">
<cfelseif Attributes.OnChange is "Submit!">
  <cfset Attributes.OnChange = "this.form.submit();">
</cfif>



<!--- USE PASSED QUERY WITHIN THIS CODE AS "MyQuery" --->
<cfset MyQuery = Evaluate("Caller.#Attributes.Query#")>


<!--- BEGIN JAVASCRIPTING --->
<cfoutput>
	<script language="JavaScript1.1" type="text/javascript">
	  // javascript code generated by the CF_TwoSelectsRelated Cold Fusion tag (Nate Weiss, 4/00)
		// loosely adapted from Nick Heinle's code originally at http://webreference.com/javascript/960902/select_boxes.html
	  var maxlength = 10;
	  OneA = new Array;

		var trueLength = OneA.length;  
		var lst = OneA.length;              

    function require_#Attributes.Name1#() {
		  with (document.#Attributes.FormName#.#Attributes.Name1#) {
			  RetVal = true;
			  if (options[selectedIndex] == null) RetVal = false;
				  else RetVal = !(options[selectedIndex].value == '');
			  if (!RetVal) alert('#Attributes.Message1#');
				return RetVal
			}
		}

    function require_#Attributes.Name2#() {
		  with (document.#Attributes.FormName#.#Attributes.Name2#) {
			  RetVal = true;
			  if (options[selectedIndex] == null) RetVal = false;
				  else RetVal = !(options[selectedIndex].value == '');
			  if (!RetVal) alert('#Attributes.Message2#');
				return RetVal
			}
		}
		
		function require_#Attributes.Name1#And#Attributes.Name2#() {
		  return ((require_#Attributes.Name1#()) && (require_#Attributes.Name2#()));
		}
		
				
		function #FunctionName# {
		   OneA.length = 0;
		   menuNum = document.#Attributes.FormName#.#Attributes.Name1#.selectedIndex;
		   if (menuNum == null) return;  
       <!--- this function gets continued in the next CFOUTPUT section --->
</CFOUTPUT>


<!--- COUNTER VARIABLE WILL HOLD NUMBER OF GROUPS (OPTIONS IN FIRST SELECT) --->
<CFSET Counter = IIF(Attributes.EmptyText1 is not "", 1, 0)>

<!--- CREATE AN "IF" STATEMENT THAT COVERS EACH ITEM IN THE FIRST SELECT BOX --->
<!--- WITHIN THE "IF" STATMENT, PRE-POPULATE ARRAY WITH CORRESPONDING ITEMS FOR SECOND SELECT  --->
<CFOUTPUT QUERY="MyQuery" GROUP="#Attributes.Display1#">
	if (menuNum == #Counter#) {
	  NewOpt = new Array;
		NewVal = new Array;
    <CFSET Counter2 = IIF(Attributes.EmptyText2 is not "", 1, 0)>
    <CFIF Attributes.EmptyText2 is not ""><CFOUTPUT>NewOpt[0] = new Option("#Attributes.EmptyText2#", ""); </CFOUTPUT></CFIF>
    <CFOUTPUT>NewOpt[#Counter2#] = new Option("#ReplaceList(MyQuery[Attributes.Display2][MyQuery.CurrentRow], "\,#Chr(9)#,#Chr(13)##Chr(10)#,',"",#Chr(13)#,#Chr(10)#",  "\\,\t,\n,\',\"",\r,\f")#", "#ReplaceList(MyQuery[Attributes.Value2][MyQuery.CurrentRow], "\,#Chr(9)#,#Chr(13)##Chr(10)#,',"",#Chr(13)#,#Chr(10)#",  "\\,\t,\n,\',\"",\r,\f")#"); <CFSET Counter2 = Counter2 + 1></CFOUTPUT>
	} <CFSET Counter = Counter + 1>
</CFOUTPUT>


<!--- finish up the ChangeMenu() function --->
<CFOUTPUT>
  tot = NewOpt.length;
	lst = document.#Attributes.FormName#.#Attributes.Name2#.options.length;
	
	for (i = lst; i > 0; i--) {
	  document.#Attributes.FormName#.#Attributes.Name2#.options[i] = null;
	}
  for (i = 0; i < tot; i++) {
	  document.#Attributes.FormName#.#Attributes.Name2#.options[i] = NewOpt[i];
	}
  <CFIF Attributes.AutoSelectFirst is "Yes">
	  document.#Attributes.FormName#.#Attributes.Name2#.options[0].selected = true;
	</CFIF>
}
</script>
</cfoutput>
<!--- DONE WITH JAVASCRIPTING.  NOW WE JUST HAVE TO DISPLAY THE FORM ELEMENTS --->


<!--- ALLOW FOR AUTO-SIZING "SHORTCUT" OF SELECT BOXES --->
<cfif Attributes.Size1 is "Auto">
  <!--- MAKE THE FIRST SELECT BE BIG ENOUGH FOR ALL OF ITS OPTIONS --->
  <cfset Attributes.Size1 = Counter>
</cfif>
<cfif Attributes.Size2 is "Auto">
  <!--- MAKE THE SECOND SELECT BE THE SAME SIZE AS THE FIRST --->
  <cfset Attributes.Size2 = Attributes.Size1>
</cfif>



<!--- OUTPUT FIRST SELECT BOX --->
<cfoutput><select name="#Attributes.Name1#" onChange="#FunctionName#" size="#Attributes.Size1#" <CFIF Attributes.class is not "">CLASS="#Attributes.class#"</CFIF>  hidefocus></cfoutput>

	<!--- SPECIAL FIRST ITEM, IF REQUESTED --->
	<cfif Attributes.EmptyText1 is not ""><cfoutput><option value="">#Attributes.EmptyText1#</option></cfoutput></cfif>
	<!--- GENERATE REMAINING ITEMS FROM QUERY --->
	<cfoutput query="MyQuery" group="#Attributes.Display1#"><option value="#MyQuery[Attributes.Value1][MyQuery.CurrentRow]#" <CFIF MyQuery[Attributes.Value1][MyQuery.CurrentRow] is Attributes.Default1>SELECTED</CFIF>>#MyQuery[Attributes.Display1][MyQuery.CurrentRow]#</option></cfoutput>
	
  <!--- "FORCE WIDTH" OPTION AT BOTTOM, IF REQUESTED --->
	<cfif Attributes.ForceWidth1 is not ""><cfoutput><option value="">#RepeatString(Attributes.ForceWidthChar, Attributes.ForceWidth1)#</option></cfoutput></cfif>
<cfoutput></select></cfoutput>


<!--- INSERT ANY REQUESTED HTML BETWEEN THE TWO SELECT BOXES --->
<cfoutput>#Attributes.HTMLBetween#</cfoutput>

<!--- OUTPUT SECOND SELECT BOX --->
<cfoutput><select name="#Attributes.Name2#" size="#Attributes.Size2#" <CFIF Attributes.onChange is not "">onChange="#Attributes.OnChange#"</CFIF> <CFIF Attributes.class is not "">CLASS="#Attributes.class#"</CFIF> hidefocus></cfoutput>
	<!--- SPECIAL FIRST ITEM, IF REQUESTED --->
	<cfif Attributes.EmptyText2 is not ""><cfoutput><option value="">#Attributes.EmptyText2#</option></cfoutput></cfif>
	
	<!--- GENERATE REMAINING ITEMS FROM QUERY --->
	<!--- WE ONLY NEED TO OUTPUT THE CHOICES FOR THE FIRST GROUP --->

		<cfloop query="MyQuery">
		  <cfif MyQuery[Attributes.Value1][MyQuery.CurrentRow] is Attributes.Default1>
			  <cfoutput><option value="#MyQuery[Attributes.Value2][MyQuery.CurrentRow]#" <CFIF (MyQuery[Attributes.Value1][MyQuery.CurrentRow] is Attributes.Default1) AND (MyQuery[Attributes.Value2][MyQuery.CurrentRow] is Attributes.Default2)>SELECTED</CFIF>>#MyQuery[Attributes.Display2][MyQuery.CurrentRow]#</option></cfoutput>
			</cfif>
		</cfloop>
		

  <cfif Val(Attributes.ExtraOptions2) GT 0>
    <cfloop from="1" to="#Val(Attributes.ExtraOptions2)#" index="i">
      <cfoutput><option value=""></option></cfoutput>
    </cfloop>
  </cfif>
  
  <!--- "FORCE WIDTH" OPTION AT BOTTOM, IF REQUESTED --->
	<cfif Attributes.ForceWidth2 is not ""><cfoutput><option value="">#RepeatString(Attributes.ForceWidthChar, Attributes.ForceWidth2)#</option></cfoutput></cfif>
<cfoutput></select></cfoutput>


<cfsetting enablecfoutputonly="NO">